using System;
using System.Collections;
using System.Runtime.InteropServices;
using System.IO;
using DynaPDF;

namespace image_extraction
{
	class Class1
	{
      private static ArrayList m_Images;
      private static bool      m_HaveError;
      private static CPDF      m_PDF;
      private static ArrayList m_Templates;

      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         m_HaveError = true;
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      static int parseBeginTemplate(IntPtr Data, IntPtr Object, int Handle, ref TPDFRect BBox, IntPtr Matrix)
      {
         if (m_Templates.Contains(Handle)) return 1; // Already handled
         try
         {
            m_Templates.Add(Handle);
            return 0;
         }catch
         {
            return -1;
         }
      }

      static int parseInsertImage(IntPtr Data, ref TPDFImage Image)
      {
         if (Image.InlineImage == 0)
         {
            if (m_Images.Contains(Image.ObjectPtr)) return 0;  // Already handled?
            try
            {
               m_Images.Add(Image.ObjectPtr);
            }catch
            {
               return -1;
            }
         }
         // If an image cannot be decompressed due to an unsupported filter or if the decoder
         // failed to decompress it then we can get a compressed image here.
         if (Image.Filter != TDecodeFilter.dfNone) return 0;
         // Note that Flate compression is no standard filter; Photoshop does not support this filter.
         if (Image.BitsPerPixel == 1)
            m_PDF.AddImage(TCompressionFilter.cfCCITT4, TImageConversionFlags.icNone, Image);
         else
            m_PDF.AddImage(TCompressionFilter.cfLZW, TImageConversionFlags.icNone, Image);
         return 0;
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            m_PDF       = new CPDF();
            m_Images    = new ArrayList(1024); // List of already handled images to enable a duplicate check
            m_Templates = new ArrayList(1024); // List to store template handles

            m_PDF.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            m_PDF.CreateNewPDF(null); // We create no PDF file in this example
            // We avoid the conversion of pages to templates
            m_PDF.SetImportFlags(TImportFlags.ifImportAll | TImportFlags.ifImportAsPage);
            if (m_PDF.OpenImportFile("../../../../../dynapdf_help.pdf", TPwdType.ptOpen, null) < 0)
            {
               Console.Write("Input file \"../../../../../dynapdf_help.pdf\" not found!\n");
               Console.Read();
               return;
            }
            m_PDF.ImportPDFFile(1, 1.0, 1.0);
            m_PDF.CloseImportFile();

            // We form fields so that we can extract images of these objects too.
            m_PDF.FlattenForm();

            TPDFParseInterface stack = new TPDFParseInterface();
            stack.BeginTemplate      = new TBeginTemplate(parseBeginTemplate);
            stack.InsertImage        = new TInsertImage(parseInsertImage);

            // We write the output file into the current directory.
            String filePath = Directory.GetCurrentDirectory() + "\\out.tif";

            // We create a multi-page TIFF image in this example.
            if (!m_PDF.CreateImage(filePath, TImageFormat.ifmTIFF)) return;

            int i;
            int pageCount = m_PDF.GetPageCount();
            for (i = 1; i <= pageCount; i++)
            {
               m_PDF.EditPage(i);
               /*
                  If you want to convert the images into a specific color space then set
                  one of the folowing flags (see also TParseFlags in CPDF.cs):

                     pfDitherImagesToBW // Floyd-Steinberg dithering.
                     pfConvImagesToGray
                     pfConvImagesToRGB
                     pfConvImagesToCMYK

                  Only one color space conversion flag must be set at time.
               */
               m_PDF.ParseContent(IntPtr.Zero, ref stack, TParseFlags.pfDecomprAllImages);
               m_PDF.EndPage();
            }
            m_PDF.CloseImage();

            if (!m_HaveError) Console.Write("TIFF image \"{0}\" successfully created!\n", filePath);

            System.Diagnostics.Process p = new System.Diagnostics.Process();
            p.StartInfo.FileName = filePath;
            p.Start();
         }catch(Exception e)
         {
            Console.Write(e.Message);
         }
         Console.Read();
		}
	}
}
